// Original Ingot Box Author Unknown
// Scripted by Karmageddon
using System;
using System.Collections;
using Server;
using Server.Prompts;
using Server.Mobiles;
using Server.ContextMenus;
using Server.Gumps;
using Server.Items;
using Server.Network;
using Server.Targeting;
using Server.Multis;
using Server.Regions;
using Server.Engines.Craft;

namespace Server.Items
{
	[FlipableAttribute( 0x2FEA, 0x2FEB )]
	public class GemBox : BaseContainer
	{
		private int m_BlueDiamond;
		private int m_BrilliantAmber;
		private int m_DarkSapphire;
		private int m_EcruCitrine;
		private int m_FireRuby;
		private int m_PerfectEmerald;
		private int m_Turquoise;
		private int m_WhitePearl;
		
		private int m_Amber;
		private int m_Amethyst;
		private int m_Citrine;
		private int m_Diamond;
		private int m_Emerald;
		private int m_Ruby;
		private int m_Sapphire;
		private int m_StarSapphire;
		private int m_Tourmaline;
		private int m_WithdrawIncrement;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int WithdrawIncrement { get { return m_WithdrawIncrement; } set { m_WithdrawIncrement = value; InvalidateProperties(); } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int BlueDiamond{ get{ return m_BlueDiamond; } set{ m_BlueDiamond = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public int BrilliantAmber{ get{ return m_BrilliantAmber; } set{ m_BrilliantAmber = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public int DarkSapphire{ get{ return m_DarkSapphire; } set{ m_DarkSapphire = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public int EcruCitrine{ get{ return m_EcruCitrine; } set{ m_EcruCitrine = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public int FireRuby{ get{ return m_FireRuby; } set{ m_FireRuby = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public int PerfectEmerald{ get{ return m_PerfectEmerald; } set{ m_PerfectEmerald = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public int Turquoise{ get{ return m_Turquoise; } set{ m_Turquoise = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public int WhitePearl{ get{ return m_WhitePearl; } set{ m_WhitePearl = value; } }
		
		//old gems
		[CommandProperty( AccessLevel.GameMaster )]
		public int Amber{ get{ return m_Amber; } set{ m_Amber = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Amethyst{ get{ return m_Amethyst; } set{ m_Amethyst = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Citrine{ get{ return m_Citrine; } set{ m_Citrine = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Diamond{ get{ return m_Diamond; } set{ m_Diamond = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Emerald{ get{ return m_Emerald; } set{ m_Emerald = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Ruby{ get{ return m_Ruby; } set{ m_Ruby = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Sapphire{ get{ return m_Sapphire; } set{ m_Sapphire = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int StarSapphire{ get{ return m_StarSapphire; } set{ m_StarSapphire = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Tourmaline{ get{ return m_Tourmaline; } set{ m_Tourmaline = value; } }

		public override bool DisplaysContent{ get{ return false; } }
		
		[Constructable]
		public GemBox() : base( 0x2FEA )
		{
			Movable = true;
			Weight = 10.0;
			Name = "Gem Box";
			WithdrawIncrement = 50;
		}
		
		[Constructable]
		public GemBox( int withdrawincrement ) : base( 0x2FEA )
		{
			Movable = true;
			Weight = 10.0;
			Name = "Gem Box";
			WithdrawIncrement = withdrawincrement;
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( !from.InRange( GetWorldLocation(), 2 ) )
				from.LocalOverheadMessage( Network.MessageType.Regular, 0x3B2, 1019045 ); // I can't reach that.
			else if ( from is PlayerMobile )
			{
				if ( !IsSecure )
				{
					from.SendMessage( "Box must be secured in house." );
				}
				else
					from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
			}
		}

      public override bool OnDragDrop( Mobile from, Item o )
      {
         return false;
      }

		public void BeginCombine( Mobile from )
		{
			from.Target = new GemBoxTarget( this );
		}

		public void EndCombine( Mobile from, object o )
		{
			if ( o is Item/* && ((Item)o).IsChildOf( from.Backpack ) */ )
			{
				if ( o is BlueDiamond )
				{

					if ( BlueDiamond >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						BlueDiamond += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is BrilliantAmber )
				{

					if ( BrilliantAmber >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						BrilliantAmber += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is DarkSapphire )
				{

					if ( DarkSapphire >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						DarkSapphire += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if (o is EcruCitrine )
				{

					if ( EcruCitrine >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						EcruCitrine += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if (o is FireRuby )
				{

					if ( FireRuby >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						FireRuby += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if (o is PerfectEmerald )
				{

					if ( PerfectEmerald >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						PerfectEmerald += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if (o is Turquoise )
				{

					if ( Turquoise >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						Turquoise += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if (o is WhitePearl )
				{

					if ( WhitePearl >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						WhitePearl += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				//old gems
				if ( o is Amber )
				{

					if ( Amber >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						Amber += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Amethyst )
				{

					if ( Amethyst >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						Amethyst += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Citrine )
				{

					if ( Citrine >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						Citrine += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Diamond )
				{

					if ( Diamond >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						Diamond += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Emerald )
				{

					if ( Emerald >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						Emerald += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Ruby )
				{

					if ( Ruby >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						Ruby += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Sapphire )
				{

					if ( Sapphire >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						Sapphire += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is StarSapphire )
				{

					if ( StarSapphire >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						StarSapphire += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Tourmaline )
				{

					if ( Tourmaline >= 99999 )
						from.SendMessage( "That Gem type is too full to add more." );
					else
					{
						Item curItem = o as Item;
						Tourmaline += curItem.Amount;
						curItem.Delete();
						from.SendGump( new GemBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
			}
			else
			{
				from.SendLocalizedMessage( 1045158 ); // You must have the item in your backpack to target it.
			}
		}

		public GemBox( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 1 ); // version
			
			writer.Write( (int) m_Amber);
			writer.Write( (int) m_Amethyst);
			writer.Write( (int) m_Citrine);
			writer.Write( (int) m_Diamond);
			writer.Write( (int) m_Emerald);
			writer.Write( (int) m_Ruby);
			writer.Write( (int) m_Sapphire);
			writer.Write( (int) m_StarSapphire);
			writer.Write( (int) m_Tourmaline);
         			
			writer.Write( (int) m_BlueDiamond);
			writer.Write( (int) m_BrilliantAmber);
			writer.Write( (int) m_DarkSapphire);
			writer.Write( (int) m_EcruCitrine);
			writer.Write( (int) m_FireRuby);
			writer.Write( (int) m_PerfectEmerald);
			writer.Write( (int) m_Turquoise);
			writer.Write( (int) m_WhitePearl);
			writer.Write( (int) m_WithdrawIncrement);
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
			switch( version )
			{
				case 1:
				{
      			m_Amber = reader.ReadInt();
      			m_Amethyst = reader.ReadInt();
      			m_Citrine = reader.ReadInt();
      			m_Diamond = reader.ReadInt();
      			m_Emerald = reader.ReadInt();
      			m_Ruby = reader.ReadInt();
      			m_Sapphire = reader.ReadInt();
      			m_StarSapphire = reader.ReadInt();
      			m_Tourmaline = reader.ReadInt();
					goto case 0;
				}
            case 0:
				{
      			m_BlueDiamond = reader.ReadInt();
      			m_BrilliantAmber = reader.ReadInt();
      			m_DarkSapphire = reader.ReadInt();
      			m_EcruCitrine = reader.ReadInt();
      			m_FireRuby = reader.ReadInt();
      			m_PerfectEmerald = reader.ReadInt();
      			m_Turquoise = reader.ReadInt();
      			m_WhitePearl = reader.ReadInt();
      			m_WithdrawIncrement = reader.ReadInt();
					break;
				}
			}
		}
	}
}


namespace Server.Items
{
	public class GemBoxGump : Gump
	{
		private PlayerMobile m_From;
		private GemBox m_Box;

		public GemBoxGump( PlayerMobile from, GemBox box ) : base( 25, 25 )
		{
			m_From = from;
			m_Box = box;

			m_From.CloseGump( typeof( GemBoxGump ) );

			AddPage( 0 );

			AddBackground( 12, 19, 440, 270, 9250);
			AddLabel( 200, 30, 32, @"Gem Box");
			
			AddLabel( 60, 50, 32, @"Add Item");
			AddButton( 25, 50, 4005, 4007, 1, GumpButtonType.Reply, 0);

			AddLabel( 60, 75, 32, @"Vyber:");
			AddButton( 25, 75, 4005, 4007, 1000, GumpButtonType.Reply, 0);
			AddImageTiled(102, 76, 50, 20, 9354);
			AddTextEntry(105, 76, 50, 20, 0x480, 500, m_Box.WithdrawIncrement.ToString() );
			
			AddLabel( 60, 115, 2219, @"Blue Diamond");
			AddLabel( 170, 115, 0x480, box.BlueDiamond.ToString() );
			AddButton( 25, 115, 4005, 4007, 3, GumpButtonType.Reply, 0);
			
			AddLabel( 60, 135, 1359, @"Brilliant Amber");
			AddLabel( 170, 135, 0x480, box.BrilliantAmber.ToString() );
			AddButton( 25, 135, 4005, 4007, 4, GumpButtonType.Reply, 0);
			
			AddLabel( 60, 155, 1155, @"Dark Sapphire");
			AddLabel( 170, 155, 0x480, box.DarkSapphire.ToString() );
			AddButton( 25, 155, 4005, 4007, 5, GumpButtonType.Reply, 0);
			
			AddLabel( 60, 175, 2116, @"Ecru Citrine");
			AddLabel( 170, 175, 0x480, box.EcruCitrine.ToString() );
			AddButton( 25, 175, 4005, 4007, 6, GumpButtonType.Reply, 0);
			
			AddLabel( 60, 195, 32, @"Fire Ruby");
			AddLabel( 170, 195, 0x480, box.FireRuby.ToString() );
			AddButton( 25, 195, 4005, 4007, 7, GumpButtonType.Reply, 0 );
			
			AddLabel( 60, 215, 2206, @"Perfect Emerald");
			AddLabel( 170, 215, 0x480, box.PerfectEmerald.ToString() );
			AddButton( 25, 215, 4005, 4007, 8, GumpButtonType.Reply, 0 );
			
			AddLabel( 60, 235, 6, @"Turquoise");
			AddLabel( 170, 235, 0x480, box.Turquoise.ToString() );
			AddButton(  25, 235, 4005, 4007, 9, GumpButtonType.Reply, 0 );
			
			AddLabel( 60, 255, 1149, @"White Pearl");
			AddLabel( 170, 255, 0x480, box.WhitePearl.ToString() );
			AddButton( 25, 255, 4005, 4007, 10, GumpButtonType.Reply, 0 );
			
			//old gems
			AddLabel( 265, 95, 149, @"Amber");
			AddLabel( 375, 95, 0x480, box.Amber.ToString() );
			AddButton( 230, 95, 4005, 4007, 11, GumpButtonType.Reply, 0);
			
			AddLabel( 265, 115, 113, @"Amethyst");
			AddLabel( 375, 115, 0x480, box.Amethyst.ToString() );
			AddButton( 230, 115, 4005, 4007, 12, GumpButtonType.Reply, 0);
			
			AddLabel( 265, 135, 242, @"Citrine");
			AddLabel( 375, 135, 0x480, box.Citrine.ToString() );
			AddButton( 230, 135, 4005, 4007, 13, GumpButtonType.Reply, 0);
			
			AddLabel( 265, 155, 195, @"Diamond");
			AddLabel( 375, 155, 0x480, box.Diamond.ToString() );
			AddButton( 230, 155, 4005, 4007, 14, GumpButtonType.Reply, 0);
			
			AddLabel( 265, 175, 167, @"Emerald");
			AddLabel( 375, 175, 0x480, box.Emerald.ToString() );
			AddButton( 230, 175, 4005, 4007, 15, GumpButtonType.Reply, 0);
			
			AddLabel( 265, 195, 132, @"Ruby");
			AddLabel( 375, 195, 0x480, box.Ruby.ToString() );
			AddButton( 230, 195, 4005, 4007, 16, GumpButtonType.Reply, 0 );
			
			AddLabel( 265, 215, 97, @"Sapphire");
			AddLabel( 375, 215, 0x480, box.Sapphire.ToString() );
			AddButton( 230, 215, 4005, 4007, 17, GumpButtonType.Reply, 0 );
			
			AddLabel( 265, 235, 91, @"Star Sapphire");
			AddLabel( 375, 235, 0x480, box.StarSapphire.ToString() );
			AddButton( 230, 235, 4005, 4007, 18, GumpButtonType.Reply, 0 );
			
			AddLabel( 265, 255, 80, @"Tourmaline");
			AddLabel( 375, 255, 0x480, box.Tourmaline.ToString() );
			AddButton( 230, 255, 4005, 4007, 19, GumpButtonType.Reply, 0 );
		}

		public override void OnResponse( NetState sender, RelayInfo info )
		{
			if ( m_Box.Deleted )
				return;
		   else if ( !m_From.InRange( m_Box.GetWorldLocation(), 5 ) )
			{
            m_From.SendMessage( "Jsi od {0} prilis daleko!", m_Box.Name );            
			   if( m_From.HasGump( typeof(GemBoxGump) ) )
				  m_From.CloseGump( typeof(GemBoxGump) );
				return;
         }
         
			if ( info.ButtonID == 1000)
			{
				int i_Withdraw = BlackSmithBoxGump.CheckWithdraw( m_From, info );
				
            if ( i_Withdraw > 0 )
				{
               m_Box.WithdrawIncrement = i_Withdraw;
               m_From.SendMessage( "Vyber nastaven na {0}", i_Withdraw );
            }
            
            m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
			}
         
			if ( info.ButtonID == 1)
			{
				m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
				m_Box.BeginCombine( m_From );
			}
			
			if ( info.ButtonID == 3 )
			{
				if ( m_Box.BlueDiamond > 0 )
				{
					if ( m_Box.BlueDiamond > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new BlueDiamond(m_Box.WithdrawIncrement) );
						m_Box.BlueDiamond = m_Box.BlueDiamond - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.BlueDiamond > 0)
					{
						m_From.AddToBackpack( new BlueDiamond(m_Box.BlueDiamond) );
						m_Box.BlueDiamond = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			
			if ( info.ButtonID == 4 )
			{
				if ( m_Box.BrilliantAmber > 0 )
				{
					if ( m_Box.BrilliantAmber > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new BrilliantAmber(m_Box.WithdrawIncrement) );
						m_Box.BrilliantAmber = m_Box.BrilliantAmber - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.BrilliantAmber > 0)
					{
						m_From.AddToBackpack( new BrilliantAmber(m_Box.BrilliantAmber) );
						m_Box.BrilliantAmber = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gems!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 5 )
			{
				if ( m_Box.DarkSapphire > 0 )
				{
					if ( m_Box.DarkSapphire > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new DarkSapphire(m_Box.WithdrawIncrement) );
						m_Box.DarkSapphire = m_Box.DarkSapphire - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.DarkSapphire> 0)
					{
						m_From.AddToBackpack( new DarkSapphire(m_Box.DarkSapphire) );
						m_Box.DarkSapphire = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 6 )
			{
				if ( m_Box.EcruCitrine > 0 )
				{
					if ( m_Box.EcruCitrine > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new EcruCitrine(m_Box.WithdrawIncrement) );
						m_Box.EcruCitrine = m_Box.EcruCitrine - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.EcruCitrine > 0)
					{
						m_From.AddToBackpack( new EcruCitrine(m_Box.EcruCitrine) );
						m_Box.EcruCitrine = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 7 )
			{
				if ( m_Box.FireRuby > 0 )
				{
					if ( m_Box.FireRuby > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new FireRuby(m_Box.WithdrawIncrement) );
						m_Box.FireRuby = m_Box.FireRuby - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.FireRuby > 0)
					{
						m_From.AddToBackpack( new FireRuby(m_Box.FireRuby) );
						m_Box.FireRuby = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 8 )
			{
				if ( m_Box.PerfectEmerald > 0 )
				{
					if ( m_Box.PerfectEmerald > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new PerfectEmerald(m_Box.WithdrawIncrement) );
						m_Box.PerfectEmerald = m_Box.PerfectEmerald - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.PerfectEmerald > 0)
					{
						m_From.AddToBackpack( new PerfectEmerald(m_Box.PerfectEmerald) );
						m_Box.PerfectEmerald = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 9 )
			{
				if ( m_Box.Turquoise > 0 )
				{
					if ( m_Box.Turquoise > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new Turquoise(m_Box.WithdrawIncrement) );
						m_Box.Turquoise = m_Box.Turquoise - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.Turquoise > 0)
					{
						m_From.AddToBackpack( new Turquoise(m_Box.Turquoise) );
						m_Box.Turquoise = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 10 )
			{
				if ( m_Box.WhitePearl > 0 )
				{
					if ( m_Box.WhitePearl > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new WhitePearl(m_Box.WithdrawIncrement) );
						m_Box.WhitePearl = m_Box.WhitePearl - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.WhitePearl > 0)
					{
						m_From.AddToBackpack( new WhitePearl(m_Box.WhitePearl) );
						m_Box.WhitePearl = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			//Old gems
			if ( info.ButtonID == 11 )
			{
				if ( m_Box.Amber > 0 )
				{
					if ( m_Box.Amber > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new Amber(m_Box.WithdrawIncrement) );
						m_Box.Amber = m_Box.Amber - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.Amber > 0)
					{
						m_From.AddToBackpack( new Amber(m_Box.Amber) );
						m_Box.Amber = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 12 )
			{
				if ( m_Box.Amethyst > 0 )
				{
					if ( m_Box.Amethyst > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new Amethyst(m_Box.WithdrawIncrement) );
						m_Box.Amethyst = m_Box.Amethyst - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.Amethyst > 0)
					{
						m_From.AddToBackpack( new Amethyst(m_Box.Amethyst) );
						m_Box.Amethyst = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 13 )
			{
				if ( m_Box.Citrine > 0 )
				{
					if ( m_Box.Citrine > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new Citrine(m_Box.WithdrawIncrement) );
						m_Box.Citrine = m_Box.Citrine - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.Citrine > 0)
					{
						m_From.AddToBackpack( new Citrine(m_Box.Citrine) );
						m_Box.Citrine = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 14 )
			{
				if ( m_Box.Diamond > 0 )
				{
					if ( m_Box.Diamond > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new Diamond(m_Box.WithdrawIncrement) );
						m_Box.Diamond = m_Box.Diamond - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.Diamond > 0)
					{
						m_From.AddToBackpack( new Diamond(m_Box.Diamond) );
						m_Box.Diamond = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 15 )
			{
				if ( m_Box.Emerald > 0 )
				{
					if ( m_Box.Emerald > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new Emerald(m_Box.WithdrawIncrement) );
						m_Box.Emerald = m_Box.Emerald - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.Emerald > 0)
					{
						m_From.AddToBackpack( new Emerald(m_Box.Emerald) );
						m_Box.Emerald = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 16 )
			{
				if ( m_Box.Ruby > 0 )
				{
					if ( m_Box.Ruby > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new Ruby(m_Box.WithdrawIncrement) );
						m_Box.Ruby = m_Box.Ruby - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.Ruby > 0)
					{
						m_From.AddToBackpack( new Ruby(m_Box.Ruby) );
						m_Box.Ruby = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 17 )
			{
				if ( m_Box.Sapphire > 0 )
				{
					if ( m_Box.Sapphire > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new Sapphire(m_Box.WithdrawIncrement) );
						m_Box.Sapphire = m_Box.Sapphire - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.Sapphire > 0)
					{
						m_From.AddToBackpack( new Sapphire(m_Box.Sapphire) );
						m_Box.Sapphire = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 18 )
			{
				if ( m_Box.StarSapphire > 0 )
				{
					if ( m_Box.StarSapphire > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new StarSapphire(m_Box.WithdrawIncrement) );
						m_Box.StarSapphire = m_Box.StarSapphire - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.StarSapphire > 0)
					{
						m_From.AddToBackpack( new StarSapphire(m_Box.StarSapphire) );
						m_Box.StarSapphire = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
			if ( info.ButtonID == 19 )
			{
				if ( m_Box.Tourmaline > 0 )
				{
					if ( m_Box.Tourmaline > m_Box.WithdrawIncrement )
					{
						m_From.AddToBackpack( new Tourmaline(m_Box.WithdrawIncrement) );
						m_Box.Tourmaline = m_Box.Tourmaline - m_Box.WithdrawIncrement;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else if (m_Box.Tourmaline > 0)
					{
						m_From.AddToBackpack( new Tourmaline(m_Box.Tourmaline) );
						m_Box.Tourmaline = 0;
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
					}
					else
					{
						m_From.SendMessage( "You do not have any of that Gem!" );
						m_From.SendGump( new GemBoxGump( m_From, m_Box ) );
						m_Box.BeginCombine( m_From );
					}
				}
			}
		}
	}

}

namespace Server.Items
{
	public class GemBoxTarget : Target
	{
		private GemBox m_Box;

		public GemBoxTarget( GemBox box ) : base( 18, false, TargetFlags.None )
		{
			m_Box = box;
		}

		protected override void OnTarget( Mobile from, object targeted )
		{
			if ( m_Box.Deleted )
				return;
			else if ( !from.InRange( m_Box.GetWorldLocation(), 5 ) )
			{
            from.SendMessage( "Jsi od {0} prilis daleko!", m_Box.Name );            
			   if( from.HasGump( typeof(GemBoxGump) ) )
				  from.CloseGump( typeof(GemBoxGump) );
				return;
         }
			else if ( targeted is Item && !from.InRange( ((Item)targeted).GetWorldLocation(), 2 ) )
			{
            from.SendMessage( "Jsi od {0} prilis daleko!", ((Item)targeted).Name );
				return;
         }
         
			m_Box.EndCombine( from, targeted );
		}
	}
}
